# Author: Jeff Comer <jeffcomer at gmail>
source useful.tcl

vmdargs makeColvarsCen.tcl psf pdb selText springConst outFile

set out [open $outFile w]
set sp "  "
mol new $psf
mol addfile $pdb
set sel [atomselect top [argSelText $selText]]
set serialList [$sel get serial]
set cen [measure center $sel weight mass]
foreach {cx cy cz} $cen { break }
$sel delete
mol delete top

puts $out "colvarsTrajFrequency     20000"
puts $out "colvarsRestartFrequency  20000"
puts $out ""
puts $out "colvar {"
puts $out "${sp}name comRestZ"
puts $out ""
puts $out "${sp}distanceZ \{" 
puts $out "${sp}${sp}main \{"
puts $out "${sp}${sp}atomNumbers \{ $serialList \}"
puts $out "${sp}\}" 
puts $out "${sp}${sp} ref \{ dummyAtom (0, 0, $cz) \}"
puts $out "${sp}\}" 
puts $out "\}" 
puts $out "" 
puts $out "harmonic \{"
puts $out "${sp}colvars comRestZ"
puts $out "${sp}centers 0.0"
puts $out "${sp}forceConstant $springConst"
puts $out "\}"
close $out

puts "Colvar involves [llength $serialList] atoms"

exit
