# Author: Jeff Comer <jeffcomer at gmail>

source useful.tcl

vmdargs markStructure.tcl psf pdb selectText occupancy beta outPdb

mol new $psf
mol addfile $pdb waitfor all

set all [atomselect top all]
puts "Zeroing occupancy and beta of all atoms."
$all set occupancy 0.0
$all set beta 0.0

set sel [atomselect top [argSelText $selectText]]
puts "Selected [$sel num] atoms."
puts "Setting occupancy $occupancy and beta $beta for the selected atoms."
$sel set occupancy $occupancy
$sel set beta $beta

$all writepdb $outPdb

$sel delete
$all delete
mol delete top
exit
