#!/usr/bin/perl
# convert a dssp output file into an stp file for i-map
#Modified by Ariela Vergara (June 19, 2015)
use strict;
use lib "$ENV{PWD}/modules";

require formats;

if (@ARGV!=2) {
    print STDERR "Usage: script <dssp file (in)> <stp file (out)>\n";
    exit;
}

my $w_full = 1;          # this value for residues not at boundaries
my $w_overlap = 0.4;     # this value will never be used
my $w_transition = 0.4;  # this value will be used only for residues that
                         # are at the boundaries of H or E ss elements

my %dssp_2_triple = (" " => "C", "T" => "C", "G" => "H", "E" => "E",
		     "I" => "C", "B" => "C", "S" => "C", "H" => "H");

my $dssp_file = $ARGV[0];
my $stp_file = $ARGV[1];

$dssp_file =~ /\/?(\w+)\./;
my $seed = $1;

my $start = 0;
my $ss_str = "";
my $aa_str = "";

open DSSP, "<$dssp_file";
while (<DSSP>) {

    $start = 1, next if (/^  \#  RESIDUE/);
    next unless $start;

    my $res_type = substr $_, 13, 1;
    next if ($res_type =~ /\!/);  # dssp reports an abnormality

    my $ss_dssp_type = substr $_, 16, 1;
    my $ss_triple_type = $dssp_2_triple{$ss_dssp_type};
    $aa_str .= $res_type;
    $ss_str .= $ss_triple_type;

}
close DSSP;

my $text = "";
my $aa_length = length ($aa_str);
die "parsing error: seq does not match ss string\n" 
    if (length ($ss_str) != $aa_length);

my %ss_hash;
$ss_hash {"QUERY $seed"} = $aa_str;
$ss_hash {"2nd_struct"} = $ss_str;

my $text = formats::toMFAFormat ("QUERY $seed",\%ss_hash);

open STP, ">$stp_file";
print STP $text;
close STP;
