#
# A collection of general file IO utilities
# 
# Created on 3/31/2002.
# Author: cltang @ honig lab 
# 
# Advertised functions:
#
# $version = &version ()
# 
# $string = &readAsciiFile ($fileName)
# &writeAsciiFile ($fileName,$text1,...,$textN)
# &appendAsciiFile ($fileName,$text1,...,$textN)
# @list = &getFiles ($dir)
# 

use strict;

package   fileio;
require   Exporter;
my @ISA = qw (Exporter);
my @EXPORT = qw (version readAsciiFile writeAsciiFile appendAsciiFile
		 getFiles);

###########
sub version
########### 
{
    print STDERR "parse Version 0.1: Mar 31, 2002\n";
    return "0.1";
}

#################
sub readAsciiFile
#################
{
    my ($fileName) = @_;
    my $tmp = $/;
    undef $/;
    open (FILE,"$fileName") or die "Cannot read $fileName.\n$!\n";
    my $retbuff = <FILE>;
    close FILE;
    $/ = $tmp;
    return $retbuff;
}

##################
sub writeAsciiFile
##################
{
    my ($fileName,@text) = @_;
    open (FILE,">$fileName") or die "Cannot write $fileName.\n$!\n";
    map {
	print FILE $_;
    } @text;
    close FILE;
}

###################
sub appendAsciiFile
###################
{
    my ($fileName,@text) = @_;
    open (FILE,">>$fileName") or die "Cannot append $fileName.\n$!\n";
    map {
	print FILE $_;
    } @text;
    close FILE;
}

############
sub getFiles
############
{
    my ($dir) = @_;
    opendir (DIR,$dir) or die "Cannot find $dir.\n$!\n";
    my @files = readdir DIR or die "Cannot read $dir.\n$!\n";
    closedir DIR;

    @files = grep !(-d $_), @files;
    return @files;
}

1;
