# A module for things for homology modeling
# project for membrane proteins 
# advertised functions

# ($ref_hash) = &hom_mod::def_dataset(); # dataset
# ($ref_hash) = &hom_mod::def_chainid(); # chain_id
# ($ref_hash) = &hom_mod::def_tmtype($ref_hash_dataset);  # tm_type


use strict; 

use lib "$ENV{SCR}/modules/";

package   hom_mod;
require   Exporter;
my @ISA = qw (Exporter);
my @EXPORT = qw (def_dataset def_chainid def_tmtype);

#### EXPORTED ####

################
# to define families and datasets
################
sub def_dataset {

my %dataset = (
    aquaporins       => ["1j4n", "1fx8", "1rc2"],
    clc              => ["1kpl", "1ots"],
    cytbc1           => ["1bcc", "1ntm", "1kb9"],
    cytcox           => ["1v54", "1ar1", "1m56"],
    mfs_transporters => ["1pv6", "1pw4"],
    opsins           => ["1m0l", "1e12", "1h68", "1u19"],
    porins           => ["1prn", "2por", "1pho", "2omf", "1osm", "1e54"],
    prc              => ["1prc", "1ogv", "1eys"],
    reductases       => ["1l0v", "1qla", "1kqf"],
    sugar_porins     => ["1oh2", "1af6", "2mpr"],
    tonb_receptors   => ["1nqe", "1kmo", "1fep", "1qfg"],
);

return (\%dataset);

}

# determine if helix bundle or beta-barrel
sub def_tmtype {

	my $rdataset = $_[0];
	my %dataset  = %$rdataset;
	my (%type, $b);

	my @bundles = qw (aquaporins clc cytbc1 cytcox mfs_transporters opsins prc reductases);
	my @barrels = qw (porins sugar_porins tonb_receptors);

	foreach my $family (keys %dataset) {

		foreach $b (@bundles) { 
			if ($b eq $family) { $type{$family} = "helical"; }
		}
		foreach $b (@barrels) { 
			if ($b eq $family) { $type{$family} = "barrel"; }
		}
		if (!$type{$family}) { warn "Problem: $family family doesn't belong in any TM type\n
helical = @bundles\nbarrel = @barrels\n"; }
	}
	return (\%type);

}

################
# to define chain identifiers
################
sub def_chainid {

my %chain_id = ( 
	"1j4n" => ["A"],
	"1fx8" => ["A"],
	"1rc2" => ["B"],
	"1kpl" => ["A", "B"], 
	"1ots" => ["A", "B"], 
	"1bcc" => ["C", "D", "E", "G", "J"], 
	"1ntm" => ["C", "D", "E", "G", "J"], 
	"1kb9" => ["C", "D", "E", "H", "I"], 
	"1v54" => ["A", "B"], 
	"1ar1" => ["A", "B"], 
	"1m56" => ["A", "B"], 
	"1m0l" => ["A"],
	"1e12" => ["A"],
	"1h68" => ["A"],
	"1u19" => ["A"],
	"1l0v" => ["C", "D"],
	"1qla" => ["C"],
	"1kqf" => ["C"], 
	"1prc" => ["L", "M"],
	"1ogv" => ["L", "M"],
	"1eys" => ["L", "M"], 
	"1pv6" => ["A"],
	"1pw4" => ["A"],
	"1prn" => ["_"],
	"2por" => ["_"],
	"1pho" => ["_"],
	"2omf" => ["_"], 
	"1osm" => ["A"],
	"1e54" => ["A"],
	"1oh2" => ["R"],
	"1af6" => ["A"], 
	"2mpr" => ["A"], 
	"1nqe" => ["A"], 
	"1kmo" => ["A"], 
	"1fep" => ["A"], 
	"1qfg" => ["A"],
);

return (\%chain_id);

}
