#!/usr/bin/perl 
# converts output from PSIPRED
# to a fasta sequence file
# lrf 1oct08
#Modified by Ariela Vergara (June 19, 2015)

use strict;
#use lib "/usr/local/scr";
#require fileio;
#require formats;
#require fasta;

my $usage = "\n$0 <options>
	-h usage\n
	-v verbose\n
	-s <ss prediction>, REQUIRED
	 Standard output file from software\n
	 Output is saved as format.fa or pdbX_format.fa\n";

# variables
my ($verbose, $infile, $outfile);

# input flags
if (@ARGV < 2) { die "$usage\n"; }
while(@ARGV) {
	$_ = shift;
	if ($_ eq "-h") { print "$usage\n"; exit; }
	elsif ($_ eq "-s") { $infile  = shift; }
	elsif ($_ eq "-v") { $verbose = 1; print STDERR "Being verbose\n" }
}
print STDERR "\nReading $infile \n";

###############################
# add protein sequence if given
my $seq;
open (IN, $infile) or die "Cannot open $infile\n"; 
while (<IN>) {
  next if /helix/; 

  next unless (/^Pred: /);
  s/^Pred: //;
  $seq .= $_;

}

#############################################################
# create fasta format of prediction
$outfile = "psipred.fa";

print STDERR "\nCreating $outfile\n\n";
open (OUT, ">$outfile");
print OUT ">Psipred\n$seq\n"; 
close OUT;
