#!/usr/bin/perl
#Modified by Ariela Vergara (June 19, 2015)
use lib "$ENV{PWD}/modules"; 

#libraries to reference
require fasta;
require formats;

if (@ARGV < 2) { die "$0 clustal_in fasta_out\n"; }
$clustal_file = $ARGV[0];
if (!-e $clustal_file) { die "Can't find $clustal_file\n"; }

$file = `cat $clustal_file`;
%clust_seq = &fasta::toMSFHash($file);
print STDERR "Converting $clustal_file Clustal format \nto $ARGV[1]	Fasta format.\nFound sequences:\n";

open(OUTBLAST, ">$ARGV[1]");
foreach $s (keys %clust_seq) {
	print OUTBLAST &formats::toFastaFormat($s,$clust_seq{$s});
	print STDERR "\t$s\n";
}
close OUTBLAST;

print STDERR "\nDone.\n";
