#
# Author: lucy forrest 
# created on December 2005
# for parsing delphi output
# 

use strict;

package  delphi;
require  Exporter;
my @ISA = qw (Exporter);
my @EXPORT = qw (read_phi read_pdb_charges);

# site(atom,potential,coulomb,charge) # reading file generated by delphi with this command
# 
# usage: (\%atom_name, \%res_name, \%res_num, \%chain, \@potential, $j) = read_phi($filename,$verbose);
# usage: (\%atom_name, \%res_name, \%res_num, \%chain, \@charge,    $j) = read_pdb_charges($filename,$verbose);
#
# do ($ratom_name, $rres_name, $rres_num, $rchain, $rcharge, $j) = read_pdb_charges($filename,$verbose);
#    %atom_name = %$ratom_name;
#    %res_name  = %$rres_name;
#    %res_num   = %$rres_num;
#    @chain     = @$rchain;
#    @potential = @$rpotential;

############
sub read_phi
############
{
    my ($filename, $v) = @_;

    my (%atom_name, %res_name, %chain, %res_num, @potential, $a, $r, $n);
    my $i = 0; # number of lines

    print STDERR "Reading $filename\n" if ($v);
    open (POTENTIALS, $filename) or die "ERROR: Can't open $filename!\n"; 

    my $line_no = 0;
    # read file
    while (<POTENTIALS>) {
    
       $line_no++;
       if ($line_no <= 12)  { next; } # skip header
       if (/ total energy/) { next; }

       $a = substr($_,0,4); $a =~ s/\s//g;
       $r = substr($_,5,3); $r =~ s/\s//g;
       $n = substr($_,11,4); $n =~ s/\s//g;

       $atom_name{"phi"}[$i] = $a; 
       $res_name{"phi"}[$i]  = $r; 
       $res_num{"phi"}[$i]   = $n; 
       $chain{"phi"}[$i]     = substr($_,9,1);

       # depends on correct formating
       my $phi           = substr($_,31,9); $phi =~ s/\s//g;
       $potential[$i] = $phi;

       # check if phi has digits
       if ($phi =~ /[a-zA-Z]/) { die "ERROR! Potential ($phi) is not a number in $filename: $_\n"; }
    
       print STDERR "$atom_name{\"phi\"}[$i],$res_name{\"phi\"}[$i],$res_num{\"phi\"}[$i],$chain{\"phi\"}[$i],$potential[$i]\n" if ($v);
       $i++;

    }
    close (POTENTIALS);
    $i -= 1;

    return (\%atom_name, \%res_name, \%res_num, \%chain, \@potential, $i);
}


####################
sub read_pdb_charges
####################
{
    my ($filename, $v) = @_;

    my (%atom_name, %res_name, %chain, %res_num, $a, $r, $n, @charge);
    my $i = 0; # number of atoms

    open (CHARGES, $filename) or die "ERROR: Can't open $filename!\n";
    print STDERR "Reading $filename\n" if ($v);
    while (<CHARGES>) {

       next unless (/^ATOM/);
       $a = substr($_,12,4); $a =~ s/\s//g;
       $r = substr($_,17,4); $r =~ s/\s//g;
       $n = substr($_,22,4); $n =~ s/\s//g;

       $atom_name{"q"}[$i] = $a;
       $res_name{"q"}[$i]  = $r;
       $res_num{"q"}[$i]   = $n;
       $chain{"q"}[$i]     = substr($_,21,1);
       $charge[$i]         = substr($_,60,6);

       print STDERR "$atom_name{\"q\"}[$i],$res_name{\"q\"}[$i],$res_num{\"q\"}[$i],$chain{\"q\"}[$i],$charge[$i]\n" if ($v);
       $i++;
    }
    close (CHARGES);
    $i -= 1;

    return (\%atom_name, \%res_name, \%res_num, \%chain, \@charge, $i);
}



