# A parsing module for general things
# lrf mar05
# 
# Usage for store_numbering, returning residue numbers for "xtal" and "renum"
# and chain id of each position for "xtal" and "renum"
# as well as number of residues for "xtal" and "renum"
# ($rarray_of_hashes, $rarray_of_hashes, $rhash) = 
#             &generic_functions::store_numbering($xtal_file_name, $renum_file_name)

use strict; 

use lib "$ENV{SCR}/modules/";

package   generic_functions;
require   Exporter;
my @ISA = qw (Exporter);
my @EXPORT = qw (store_numbering);

#### EXPORTED ####

################
# to convert numbering from xtal to renum and v.v
################
sub store_numbering {

	my (@res_num, @chain, %num_res, $xtal_file, $renum_file, $name, $position);

 	# input two filenames (xtal and renum)
	($xtal_file, $renum_file) = @_;

	if (!-e $xtal_file)  { die "Couldn't open $xtal_file\n"; }
	if (!-e $renum_file) { die "Couldn't open $renum_file\n"; }

	open (XTAL, $xtal_file) or die "Couldn't open $xtal_file\n";
	print STDERR "Reading $xtal_file\n";

	# read all residues in original xtal file
	$position = 0;
	$name     = "xtal";
	while (<XTAL>) {
	
		next unless /^ATOM/;
		my $atom_name = substr($_,12,4);
		$atom_name =~ s/\s+//g; # remove spaces

		# start new amino acid
		if ($atom_name eq "N") { 
			my $c    = substr($_,21,1); 
			my $rnum = substr($_,22,4);
			$rnum    =~ s/\s+//g; # remove spaces
			if ($c eq " ") { $c = "_"; } # replace spaces
			
			# store residue number at this position
			$res_num[$position]{$name} = $rnum;
			$chain[$position]{$name}   = $c;
			$position++;
		}
	} # end read list
	close XTAL;
	$num_res{$name} = $position;

	# read all residues in renumbered file
	open (RENUM, $renum_file) or die "Couldn't open $renum_file\n";
	print STDERR "Reading $renum_file\n";
	$position = 0;
	$name     = "renum";
	while (<RENUM>) {
	
		next unless /^ATOM/;
		my $atom_name = substr($_,12,4);
		$atom_name =~ s/\s+//g; # remove spaces

		# start new amino acid
		if ($atom_name eq "N") { 
			my $c    = substr($_,21,1); 
			my $rnum = substr($_,22,4);
			$rnum    =~ s/\s+//g; # remove spaces
			if ($c eq " ") { $c = "_"; } # replace spaces
			
			# store residue number at this position
			$res_num[$position]{$name} = $rnum;
			$chain[$position]{$name}   = $c;
			$position++;
		}
	} # end read list
	close RENUM;
	$num_res{$name} = $position;

	# error check
	if ($num_res{"xtal"} ne $num_res{"renum"}) {
		#for (my $i = 0; $i < $num_res{"xtal"}; $i++) {
		#	print STDERR "XTAL: $i\t$res_num[$i]{\"xtal\"}\tRENUM: $i\t$res_num[$i]{\"renum\"}\n"; 
		#}
		warn "Number of amino acids in $xtal_file = $num_res{\"xtal\"}
        Number of amino acids in $renum_file = $num_res{\"renum\"}\n\n";
	}
	
	return (\@res_num, \@chain, \%num_res);

}

