package   pudgeUtil;
#
# A collection of utilities for pudge
# 
# Created on 12/16/2004.
# Author: ikoh @ Honig Lab 
# 
# Advertised functions:
#
# $version = &version ()
# 
# &target2Fasta ($target)
# %method = &readMtdRdb ($fileName)
# %method = &readMtd ($methodId)
# $target = &findTgtByChain ($chain)
# 

use strict;
use lib qw(/razor/4/norel/perllib); #need NFSLock installed locally on my dir
use LWP::Simple; #why getting error?

require   Exporter;
my @ISA = qw (Exporter);
my @EXPORT = qw (version target2Fasta readMtdRdbByID findTgtByChain
		addData2Config addMtd2Config setupMtdWrkDir launchCmnd
		getIdHash getIdList
		get_scop_pdbstyle_file
                
		 );


$ENV{MOUNTDIR} = "/razor/0" if( ! $ENV{MOUNTDIR} );
my $methodDb = "$ENV{PUDGE}/"."mtd/mtd.rdb";
my $APR = "http://luna.bioc.columbia.edu/honiglab/pudge/cgi-bin/show_results.cgi";
my $admin_mail = 'mailto:honig_software@c2b2.columbia.edu';
my $admin_name  = 'Raquel Norel';

###########
sub version
########### 
{
    print STDERR "parse Version 0.1: Dec 16, 2004\n";
    return "0.1";
}


################
sub checkEnvironment
################
{

getPipelineData();

if(!-d "$main::pdg_root_dir/bin") {
  print STDERR "Can not find $main::pdg_root_dir/bin.  Exiting\n";
  }

}




################
sub target2Fasta
################
{
    my ($target) = @_;
    my $dat_dir = "$ENV{PUDGE}"."/dat/";
    my $seq_dat_dir = "$dat_dir"."seq/";
    my $targetDb = "$dat_dir"."target.rdb";
    my $chain_id;

    open (FILE,"$targetDb") or die "Cannot read $targetDb.\n$!\n";
    while( <FILE> )
    {
	if( (/^(\S+)\t(\S+)$/) && ($1 eq $target) )
	{
	    $chain_id = $2;
	}
    }
    close FILE;

    my $fastaFile = "$seq_dat_dir"."$chain_id"."\.fa";
    my $targetFile = "$seq_dat_dir"."$target"."\.fa";
    open(FASTA,"<$fastaFile") or die "Cannot open fasta file $fastaFile\n";
    open(OUTFASTA,">$targetFile") or die "Cannot open fasta file $targetFile\n";
    while(<FASTA>)
    {
	if( /^(\>\s*$chain_id)(.*)$/ )
	{
	    print OUTFASTA "> $target$2\n";
	}
	else
	{
	    print OUTFASTA $_;
	}
    }
    close FASTA;
    close OUTFASTA;

    return $targetFile;
}

##############
sub readMtdRdbByID
##############
{
    my $file = shift;
    open(IN,"<$file") or die "Cannot open method rdb file\n";
    my %methods;

    while( <IN> )
    {
        next if( /^#/ );

        if( /^(\S+)\t(\S+)\t(\S+)\t(.+)\t(\S+)\t(\S+)\t(\S+)$/ )
        {
            $methods{$1}{name} = $2;
            $methods{$1}{format} = $3;
            $methods{$1}{description} = $4;
            $methods{$1}{date} = $5;
            $methods{$1}{author} = $6;
            $methods{$1}{type} = $7;
        }
    }
    close(IN);

    return %methods;
}

####################
sub readMtdRdbByName
####################
{
    my $file = shift;
    open(IN,"<$file") or die "Cannot open method rdb file\n";
    my %methods;

    while( <IN> )
    {
        next if( /^#/ );

        if( /^(\S+)\t(\S+)\t(\S+)\t(.+)\t(\S+)\t(\S+)\t(\S+)$/ )
        {
            $methods{$2}{id} = $1;
            $methods{$2}{format} = $3;
            $methods{$2}{description} = $4;
            $methods{$2}{date} = $5;
            $methods{$2}{author} = $6;
            $methods{$2}{type} = $7;
        }
    }
    close(IN);

    return %methods;
}

###########
sub readMtd
###########
{
    my ($methodId) = @_;
    my %method;
    open (FILE,"$methodDb") or die "Cannot read $methodDb.\n$!\n";
    while( <FILE> )
    {
	if( (/^(\S*)\t(\S+)\t(\S+)\t(.+)\t(\S+)\t(\S+)\t(\S+)$/) && ($1 eq $methodId) )
	{
	    $method{name} = $2;
	    $method{format} = $3;
	    $method{description} = $4;
	    $method{date} = $5;
	    $method{author} = $6;
	    $method{type} = $7;
	}
    }
    close FILE;
    return %method;
}

##################
sub setupMtdWrkDir
##################
{

my $ref_cfg=shift;
my %cfg=%$ref_cfg;
my $wrk_dir=shift;
my $target=shift;

getPipelineData();

# for each method, write scripts in working directory
my @steps=("T", "A", "M", "R", "E", "Ta", "Aa", "Ma", "Ra", "Ea", );
my $stp;

foreach $stp ( @steps ) {
  my $selmtds=$cfg{$stp};
  my @mtds=split(/,/,$selmtds);
  my $mtd;
  foreach $mtd (@mtds) { 
    my $mtd_scr = "$main::pdg_mtd_scr_dir"."$mtd"."\.sh";
    if( -e $mtd_scr ) {
      my $mtd_wrk_dir = "$wrk_dir/$mtd"."\/";
      if(!-d $mtd_wrk_dir) { 
        system("mkdir $mtd_wrk_dir; chmod 777  $mtd_wrk_dir"); }
      if( ! -d $mtd_wrk_dir ) {
        print STDERR "Failed to create method directory $wrk_dir\n";
        exit;
        }
      my $scrMaster = "$target"."_"."$mtd"."\.sh";
      system("cd $mtd_wrk_dir; cat $main::pdg_scrTop > $scrMaster; cat $mtd_scr >> $scrMaster; chmod 755 $scrMaster;");
      }
    else {
      print STDERR "Method script $mtd_scr not found.  This method will be ignored.\n";
      next;
      }
    }
  }

my $wd_t =  $wrk_dir."/templates";
my $wd_m =  $wrk_dir."/models";
my $wd_a =  $wrk_dir."/alignments";
my $wd_p =  $wrk_dir."/tpr";
if (! -e $wd_t){
   `mkdir $wrk_dir/templates`; `chmod 777  $wrk_dir/templates`;
}
if (! -e $wd_m){
   `mkdir $wrk_dir/models`;  `chmod 777  $wrk_dir/models`;
}
if (! -e $wd_a){
   `mkdir $wrk_dir/alignments`;  `chmod 777  $wrk_dir/alignments`;
}
if (! -e $wd_p){
   `mkdir $wrk_dir/tpr`;  `chmod 777  $wrk_dir/tpr`;
}

}

##################
sub findTgtByChain
##################
{
    my $chain_id = shift;
    my $dat_dir = "$ENV{PUDGE}"."/dat/";
    my $seq_dat_dir = "$dat_dir"."seq/";
    my $targetDb = "$dat_dir"."target.rdb";

    open (FILE,"$targetDb") or die "Cannot read $targetDb.\n$!\n";
    while( <FILE> )
    {
	if( (/^(\S+)\t(\S+)$/) && ($2 eq $chain_id) )
	{
	    close FILE;
	    return $1;
	}
    }
    close FILE;
}


##################
sub addData2Config
##################
{
    my($cfg_file,$type,$file) = @_;
    my $text = "";
    my $found = 0;

    open(IN,"<$cfg_file");
    while(<IN>)
    {
	if( /^$type:/ )
	{
	    $found = 1;
	    chomp;
	    $text .= $_;
	    $text .= ",$file\n";
	}
	else
	{
	    $text .= $_;
	}
    }
    close(IN);
    if( ! $found )
    {
	$text .= "$type:\t$file\n";
    }
    open(CFG,">$cfg_file");
    print CFG $text;
    close(CFG);
}



##############
sub readConfig
##############
{
    my ($cfg_file) = @_;
    my %config;

    open(CFG,"<$cfg_file") or die "Config file $cfg_file not found\n";
    while(<CFG>)
    {
	chomp;
        $_=cleanCfgLine($_);

        if(!$_) { next; }

	if( /^target_seq:\t(.*)/ )
	{
	    $config{target_seq} = $1;
	}
	elsif( /^target_pdb:\t(.*)/ )
	{
	    $config{target_pdb} = $1;
	}
	elsif( /^templates:\t(.*)/ )
	{
	    $config{templates} = $1;
	}
	elsif( /^alignments:\t(.*)/ )
	{
	    $config{alignments} = $1;
	}
	elsif( /^models:\t(.*)/ )
	{
	    $config{models} = $1;
	}
	elsif( /^exclude_templates:\t(.*)/ )
	{
	    $config{exclude_templates} = $1;
	}
	elsif( /^use_data:\t(.*)/ )
	{
	    $config{use_data} = $1;
	}
	elsif( /^target_astral:\t(.*)/ )
	{
	    $config{target_astral} = $1;
	}
	elsif( /^template_selection/ )
	{
	    if( /analysis:\t(.*)/ )
	    {
		$config{Ta} = $1;
	    }
	    elsif( /output:\t(.*)/ )
	    {
		$config{To} = $1;
	    }
	    elsif( /:\t(.*)/ )
	    {
		$config{T} = $1;
	    }
	}
	elsif( /^alignment/ )
	{
	    if( /analysis:\t(.*)/ )
	    {
		$config{Aa} = $1;
	    }
	    elsif( /output:\t(.*)/ )
	    {
		$config{Ao} = $1;
	    }
	    elsif( /:\t(.*)/ )
	    {
		$config{A} = $1;
	    }
	}
	elsif( /^model_building/ )
	{
	    if( /analysis:\t(.*)/ )
	    {
		$config{Ma} = $1;
	    }
	    elsif( /output:\t(.*)/ )
	    {
		$config{Mo} = $1;
	    }
	    elsif( /:\t(.*)/ )
	    {
		$config{M} = $1;
	    }
	}
	elsif( /^model_refinement/ )
	{
	    if( /analysis:\t(.*)/ )
	    {
		$config{Ra} = $1;
	    }
	    elsif( /output:\t(.*)/ )
	    {
		$config{Ro} = $1;
	    }
	    elsif( /:\t(.*)/ )
	    {
		$config{R} = $1;
	    }
	}
	elsif( /^model_evaluation/ )
	{
	    if( /analysis:\t(.*)/ )
	    {
		$config{Ea} = $1;
	    }
	    elsif( /output:\t(.*)/ )
	    {
		$config{Eo} = $1;
	    }
	    elsif( /:\t(.*)/ )
	    {
		$config{E} = $1;
	    }
	}
	else
	{
        print STDERR "Line not recognized: $_\n";
	}
    }
    close(CFG);

    return \%config;
}

##################
sub domainByTarget
##################
{
    my ( $file,$target ) = @_;
                                                                                
    open(IN,"<$file") or die "Cannot open database file $file\n";
    while (<IN>) {
        next if ( $_ !~ /\w+/ );
        next if ( /^\#/ );
        chomp();
                                                                                
        if( (/^(\S+)\s(\S+)/) && ($1 eq $target) )   # Pxxxxx   domain_id
        {
            close IN;
            return $2;
        }
    }
    close IN;
}

##############
sub launchCmnd
##############
{
    my ($cmnd,$wrk_dir,$mtd_wrk_dir,$jobid) = @_;
    my $launch_scr = "$ENV{MOUNTDIR}/common/scripts/modules/web/launch_job.pl";
    # do the move on thing inside method script... so that it knows
    # what the result file is.
    #my $moveOn_scr = "$ENV{MOUNTDIR}/common/pudge/scr/moveOn.pl";
    my $wrapper = "cd $mtd_wrk_dir".";"."$cmnd".";".
		  "$launch_scr -l DESCHEDULE -a . -j $jobid -d $wrk_dir";
    #$wrapper .= "$moveOn_scr";
    my $scr = "$wrk_dir"."scr"."\/"."$jobid";
                                                                                
    open(SCR,">$scr") or die "Cannot open $scr";
    print SCR "$wrapper\n";
    close(SCR);
    system("chmod 755 $scr");
                                                                                
    #print STDERR "Command: $cmnd\n";
    system("$launch_scr -l SCHEDULE -a . -j $jobid -d $wrk_dir");
}

#############
sub getIdHash
#############
{
    my $sbr = "getIdHash";
    my ( $fileList ) = @_;
    my ( $fhList,$id,%idHash );

    return () if ( ! -f $fileList );
    #$fhList = "TMP_";
    open ( IN, $fileList) or die "cannot open $fileList:$!";
    while (<IN>) {
        next if ( $_ !~ /\w+/ );
        next if ( /^\#/ );
        chomp($id=$_);
        $id =~ s/^\s+//g;
        $id =~ s/\s+.*//g;
        $id =~ s/\..*//g;
        $idHash{$id} = 1 if( $id );
    }
    close IN;	#$fhList;
    return %idHash;
}

#############
sub getIdList
#############
{
    my $sbr = "getIdList";
    my ( $fileList ) = @_;
    my ( $fhList,$id,@idList );

    return () if ( ! -f $fileList );
    @idList = ();
    #$fhList = "TMP_";
    open ( IN, $fileList) or die "cannot open $fileList:$!";
    while (<IN>) {
        next if ( $_ !~ /\w+/ );
        next if ( /^\#/ );
        chomp($id=$_);
        $id =~ s/^\s+//g;
        $id =~ s/\s+.*//g;
        $id =~ s/\..*//g;
        push @idList, $id if ( $id );
    }
    close IN;	#$fhList;
    return [@idList];
}

#############
sub getPipelineData
#############
{
$main::pdg_mnt_dir = "$ENV{MOUNTDIR}/";
$main::pdg_root_dir = "$ENV{PUDGE}/";
$main::pdg_cur_tgt = $main::pdg_root_dir."dat/tgtctr.dat";
$main::pdg_cur_mtd = $main::pdg_root_dir."dat/mtdctr.dat";
$main::pdg_cfg_dir = "$main::pdg_root_dir"."cfg/";
$main::pdg_dat_dir = "$main::pdg_root_dir"."dat/";
$main::pdg_tgt_db = "$main::pdg_dat_dir"."target.rdb";
$main::pdg_seq_dat_dir = "$main::pdg_dat_dir"."seq/";
$main::pdg_mtd_dir = "$main::pdg_root_dir"."mtd/";
$main::pdg_mtd_db = "$main::pdg_mtd_dir"."mtd.rdb";
$main::pdg_scrTop = "$main::pdg_mtd_dir"."scr/scrTop.sh";
$main::pdg_scrBot = "$main::pdg_mtd_dir"."scr/scrBot.sh";
$main::pdg_mtd_scr_dir = "$main::pdg_mtd_dir"."scr/";
$main::pdg_scr_dir = "$main::pdg_root_dir"."scr/";
$main::pdg_tst_dir = "$main::pdg_dat_dir"."tst/";
$main::pdg_lig_dir = "$main::pdg_dat_dir"."lig/";
$main::pdg_wrk_dir = "$main::pdg_root_dir"."wrk/";
$main::pdg_seqdb_dir = "$main::pdg_dat_dir"."seqdb/";
$main::pdg_strdb_dir = "$main::pdg_dat_dir"."strdb/";
$main::pdg_msa_dir = "$main::pdg_dat_dir"."msa/";
$main::pdg_bin = "$main::pdg_root_dir"."bin/";
%main::methods = readMtdRdbByID($main::pdg_mtd_db);

%main::pdg_cfg_dat=( 
  "target_seq", "target_seq",
  "target_pdb", "target_pdb",
  "templates", "templates",
  "exclude_templates", "exclude_templates",
  "models", "models",
  "use_data", "use_data",
  "alignments", "alignments",
  "template_selection", "T",
  "alignment", "A",
  "model_building", "M",
  "model_refinement", "R",
  "model_evaluation", "E",
  "template_selection_analysis", "Ta",
  "alignment_analysis", "Aa",
  "model_building_analysis", "Ma",
  "model_refinement_analysis", "Ra",
  "model_evaluation_analysis", "Ea",
  "template_selection_output", "To",
  "alignment_output", "Ao",
  "model_building_output", "Mo",
  "model_refinement_output", "Ro",
  "model_evaluation_output", "Eo" );

my @pardata=`cat $main::pdg_dat_dir/parameters`;

$main::parameters=();

my $line;

foreach $line (@pardata) { 
  chop($line); 
  my @data=split(/[: \t]+/,$line);
  $main::parameters{$data[0]}=$data[1];
  }

}



#############
sub getNextTargetId
#############
{
                                                                                                                     
getPipelineData();

use File::NFSLock qw(uncache);
use Fcntl qw(LOCK_EX LOCK_NB);

my $fn = $main::pdg_cur_tgt;
my $lock = new File::NFSLock ($fn, LOCK_EX)
    or print "Ouch1, problems with NFSlock  \n"; # blocking lock (Exclusive)
#open (FH, "+< $fn") or die "cannot open $fn \n";#update file, writes and reads...
open (FH, "< $fn") or die "cannot open $fn \n";
my $tid;
while (<FH>){
  chomp $_;
  $tid = $_;
} 
close FH;
                                                                                                                     
my $newtgt=sprintf("P%05i",$tid+1);
                                                                                                                     
$tid++;
open (FH, "> $fn") or die "cannot open $fn \n";
  print FH "$tid\n";
close FH;
`dos2unix $fn >& /dev/null`;
return $newtgt;
}

#############
sub getNextMethodId
#############
{
                                                                                                                                  
getPipelineData();
                                                                                                                                  
use File::NFSLock qw(uncache);
use Fcntl qw(LOCK_EX LOCK_NB);
                                                                                                                                  
my $fn = $main::pdg_cur_mtd;
my $lock = new File::NFSLock ($fn, LOCK_EX)
    or print "Ouch1, problems with NFSlock  \n"; # blocking lock (Exclusive)
open (FH, "< $fn") or die "cannot open $fn \n";
my $tid;
while (<FH>){
  chomp $_;
  $tid = $_;
}
close FH;
                                                                                                                                  
my $newtgt=sprintf("M%04i",$tid+1);
                                                                                                                                  
$tid++;
open (FH, "> $fn") or die "cannot open $fn \n";
  print FH "$tid\n";
close FH;
`dos2unix $fn >& /dev/null`;
return $newtgt;
}



#############
sub cleanCfgLine
#############
{

my $ln = shift;

# remove spaces

$ln =~ s/ //g;

# make sure there is only one tab

$ln =~ s/[\t]+/\t/;

return $ln;

}



#############
sub writeTgtRecord
#############
{

my $ln = shift;
my $tgt_db = shift;

open(OUT,">>$tgt_db") or die "Cannot write to $tgt_db\n";
print OUT $ln;
close OUT;

}



#############
sub writeFullConfig
#############
{

my $file = shift;
my $ref_cfg = shift;

my %cfg = %$ref_cfg;

getPipelineData();

open(OUT,">$file") or die "Cannot open file $file\n";

my $key;

foreach $key ( keys %main::pdg_cfg_dat ) {
  if( !$cfg{$main::pdg_cfg_dat{$key}}) {
    print STDERR "pudgeUtil::writeFullConfig: All methods must be specified before writing full config file.\n";
    print STDERR "  missing $key\n";
    exit(-1);
    }
  }

foreach $key ( keys %main::pdg_cfg_dat ) {
  my $mtds=$cfg{$main::pdg_cfg_dat{$key}};
  print OUT "$key:\t$mtds\n";
  }

close OUT;

`chmod a+rw $file`;

}


#############
sub printConfig
#############
{

my $ref_cfg = shift;

my %cfg = %$ref_cfg;

getPipelineData();

my $key;
foreach $key ( keys %main::pdg_cfg_dat ) {
  my $mtds=$cfg{$main::pdg_cfg_dat{$key}};
  print "$key:\t$mtds\n";
  }

}

#############
sub printConfigSimple
#############
{
                                                                                                                
my $ref_cfg = shift;
                                                                                                                
my %cfg = %$ref_cfg;
                                                                                                                
getPipelineData();
my %methodByNames = &pudgeUtil::readMtdRdbByName($main::pdg_mtd_db);
my %mtddb = &pudgeUtil::readMtdRdbByID($main::pdg_mtd_db);
                                                                                                                
my $key;
my $text = '';
foreach $key ( keys %main::pdg_cfg_dat ) {
  my $mtds=$cfg{$main::pdg_cfg_dat{$key}};
  if (($mtds ne 'none')  && ($key  ne 'target_seq')){
     #can ask for more than 1 method, need to split
     my $mtdnm=$mtddb{$mtds}{name};
     if ($mtdnm !~ /no_/){
         #print "$key:";
         $text .=  "$key:";
         my @parts = split(',',$mtds);
         foreach (@parts){
            $mtdnm=$mtddb{$_}{name};
             #print "\t$mtdnm ";
             $text .= "\t$mtdnm ";
         }
         #print "\n";
         $text .=  "\n";
         #print "$key:\t$mtdnm\n";
     }
  }
  elsif ($key  eq 'target_seq'){
      #print "$key:\t$mtds\n";
      $text .=  "$key:\t$mtds\n";
  }

  }
  return ($text);                                                                                                              
}


#############
sub writeFullConfigID
#############
{

my $file = shift;
my $ref_cfg = shift;

my %cfg = %$ref_cfg;
my %methodByNames = &pudgeUtil::readMtdRdbByName($main::pdg_mtd_db);

getPipelineData();

open(OUT,">$file") or die "Cannot open file $file\n";

my $key;

foreach $key ( keys %main::pdg_cfg_dat ) {
  if( !$cfg{$main::pdg_cfg_dat{$key}}) {
    print STDERR "pudgeUtil::writeFullConfig: All method must be specified before writing full config file.\n";
    print STDERR "  missing $key\n";
    exit(-1);
    }
  }

foreach $key ( keys %main::pdg_cfg_dat ) {
  my $mtds=$cfg{$main::pdg_cfg_dat{$key}};
  my $mtdline="$key:\t$mtds\n";

  my @data=split(/,/,$mtds);

  foreach my $method (@data) {
    my $id=$methodByNames{$method}{id};
    if($method =~ /^use_/) { next; }
    if($id eq "") { $id=$method; }
    $mtdline =~ s/$method/$id/;
    }
  
  print OUT $mtdline;

  }

print OUT "\n";

close OUT;

`chmod a+rw $file`;

}



#############
sub parsePipelineData
#############
{

$main::pdg_wrk_dir=$ENV{WRKDIR};

}


##############
sub waitForProcessors
##############
{

my $job = shift;
my $host=$ENV{HOST};
my $maxjobs=112;
if($host =~ /gaia/) { $maxjobs=400; }

my $cmd="qstat | wc -l";

my $jobcount=`$cmd`;

my $timer=0;
if($jobcount-2>=$maxjobs) {
  print STDERR "Load too large ($jobcount jobs, maxjobs: $maxjobs), waiting for processors.\n";
  }

while($jobcount>=$maxjobs) { 
  $timer+=10;
#  if($timer>86400) {
#    print STDERR "Waited full day to submit job $job.  Giving up.\n";
#    exit(-1);
#    }
  sleep(10);
  $jobcount=`$cmd`;
  }


}




##############
sub waitForJobs
##############
{
                                                                                                                                                             
my $label=shift;
my $sleeptime=shift;
my $timeout =shift;#in days
                                                                                                                                                             
if($sleeptime==0.0) { $sleeptime=30; }
if($timeout < 1) { $timeout = 2};
                                                                                                                                                             
if(!$label) {
  print STDERR "You must provide a job label to wait for jobs\n";
  return;
  }
                                                                                                                                                             
if($label eq "") {
  print STDERR "Invalid label (empty)\n";
  exit -1;
  }
                                                                                                                                                             
while(1) {
  my @jobs=`qstat | grep $label`;
  if(!@jobs) { last; }
  my $job;
  foreach $job (@jobs) {
    my $status=substr($job,38,1);
    my @parts = split(' ',$job);
    if($status eq "E") {
      my @data=split(/ +/,$job);
      my $jobid=$data[1];
      print STDERR "Job $jobid did not complete.  Trying to clear.\n";
      `qmod -c $jobid`;
      }
     if($parts[4] eq "r") {#is it running for too long?
        my $jobid=$parts[0];
        my $cpu = `qstat -j $jobid | grep cpu`;
        $cpu =~ /cpu=(.*?),/;
        my @days = split(":",$1);
        if ($#days == 3){ #already in days of cpu
           if ($days[0] >= $timeout){
              print STDERR "Job $jobid has been ruuning too long (cpu: $1). Killing it\n";
              `qdel $jobid`;
           }
        }
     }
    }
  sleep($sleeptime);
  }
}



##############
sub runPipelineStep
##############
{
my ($target,$ref_cfg,$type,$input,$moveon) = @_;
my %cfg = %$ref_cfg;
my ($mtd,$scr,$cmnd);
my $mtd_wrk_dir;

getTargetData($target);

print STDERR "Launching pipeline step: $type with input $input\n";

my @launchMtds = split(/,/,$cfg{$type});
foreach $mtd ( @launchMtds ) {

  $scr = "$main::tgt_wrk_dir"."$mtd"."\/"."$target"."_"."$mtd"."\.sh";
  $mtd_wrk_dir = "$main::tgt_wrk_dir"."$mtd";

  if(!-d $mtd_wrk_dir) {
    print STDERR "Method working directory $mtd_wrk_dir does not exist.  Exiting\n";
    exit -1;
    }

# Make unique directory for this method.
  my $i=0;
  while(1) {
    $i++;
    my $cmd="mkdir $mtd_wrk_dir/results.$i >& /dev/null";
    `$cmd`;
    if(!$?) { `chmod a+rw $mtd_wrk_dir/results.$i`; last; }
    }

  my $output_dir = "$mtd_wrk_dir/results.$i";

  my $mtd_name=$main::methods{$mtd}{name};

  if( ! -e $scr ) {
    print STDERR "Method $mtd skipped; script ($scr) not found.\n";
    next;
    }

# launch script.  Input depends on whether it is a main method
# or an analysis method.  If main, input comes from previous step
# If analysis, input comes from same step;

  $cmnd = "$scr -p $target -m $mtd -c $type -w $output_dir -t $main::tgt_wrk_dir";

  if($input) { $cmnd .= " -i ".$input; }

  my $submitscr=$output_dir."/s$target"."_"."$mtd"."\.sh";
  system("echo $cmnd > $submitscr");
  if (! -e $submitscr) {
    print STDERR "Could not create submit script ($submitscr)";
    exit(-1);
    }

  my $moveonln="$main::pdg_root_dir/scr/moveOn.pl -i $output_dir/results -t $type -p $target -m $mtd -w $output_dir -s $moveon";
  system("echo $moveonln >> $submitscr");

# run default methods directly rather than submitting to queue

  my $typename;
  my $key;
  foreach $key ( keys %main::pdg_cfg_dat ) {
    if( $main::pdg_cfg_dat{$key} eq $type) { $typename=$key; last; }
    }

  $mtd_name=$main::methods{$mtd}{name};
  if( $mtd_name =~ /swp/ ) {
    my $shcmd="(sh $submitscr > $output_dir/output ) >& $output_dir/errors";
    system($shcmd);
    }
  if( $mtd_name =~ /no_/ || $mtd_name =~ /use_/ ) {
    if( $mtd_name =~ /$typename/ ) {
      print STDERR "Method $mtd is default, running directly\n";
      }
    my $shcmd="(sh $submitscr > $output_dir/output ) >& $output_dir/errors";
    system($shcmd);
    }
  else {
    waitForProcessors($scr);
    system("qsub -cwd -e $output_dir/errors -o $output_dir/output $submitscr");
    }
  }

}



#############
sub getTargetData
#############
{

my $tid = shift;

getPipelineData();

$main::tgt_wrk_dir = $main::pdg_root_dir."wrk/".$tid."/";

}


#############
sub saveAllOutput
#############
{

my $target=shift;
my $ref_cfg=shift;
my %cfg = %$ref_cfg;

getTargetData($target);

my @pipsteps=( "T", "A", "M", "R", "E" );

my $step;
foreach $step ( @pipsteps ) {

  my $mtdlist=$cfg{$step};
  my @methods=split(/,/,$mtdlist);
  my $mtd;
  foreach $mtd (@methods) { saveOutput($target,$mtd,$step,$ref_cfg); }

  $mtdlist=$cfg{$step."a"};
  @methods=split(/,/,$mtdlist);
  foreach $mtd (@methods) { saveOutput($target,$mtd,$step,$ref_cfg); }
  }

if($cfg{To} ne "none") { saveDir("templates",$cfg{To},$target); }
if($cfg{Ao} ne "none") { saveDir("alignments",$cfg{Ao},$target); }
if($cfg{Mo} ne "none") { saveDir("models",$cfg{Mo},$target); }

}


#############
sub pipelineDone
#############
{

my $target=shift;
my $ref_cfg=shift;
my %cfg = %$ref_cfg;


getPipelineData();
&pudgeUtil::getTargetData($target);

my %mtddb = &pudgeUtil::readMtdRdbByID($main::pdg_mtd_db);

my @pipsteps=( "T", "A", "M", "R", "E", "Ta", "Aa", "Ma", "Ra", "Ea" );

my $step;
foreach $step ( @pipsteps ) {

  my $mtdlist=$cfg{$step};
  my @methods=split(/,/,$mtdlist);
  my $mtd;
  
  foreach $mtd (@methods) { 
    my $cmd="ls -1 -d $main::tgt_wrk_dir".$mtd."/results.*";
    my @outdirs=`$cmd`;
    if(!@outdirs) { 
      my $mtdnm=$mtddb{$mtd}{name};
      if(substr($mtdnm,0,3) ne "no_") { return 0; }
      }
    my $directory;
    foreach $directory (@outdirs) {
      chop $directory;
      if(! -e "$directory/$mtd.done") { return 0; }
      }
    }
  }
  
print STDERR "DONE!!!\n";  
`rm $main::tgt_wrk_dir/lock`; #was not being removed by MoveOn, patch

return 1;

}



 
#############
sub saveOutput
#############
{

my $target=shift;
my $mtd=shift;
my $type=shift;
my $ref_cfg=shift;
my %cfg = %$ref_cfg;

getTargetData($target);

my %methods = &pudgeUtil::readMtdRdbByID($main::pdg_mtd_db);

my $mtd_wrk_dir=$main::tgt_wrk_dir."$mtd/";
my $mtd_name=$methods{$mtd}{name};

my $output_dir=$cfg{$type."o"};
if($output_dir eq "none") {
  print STDERR "No output directory specified for step $type\n";
  return;
  }

print "saving output\n";
my $basedir="$output_dir/$mtd_name.$target";
my $todir=$basedir;
my $i=2;
while(1) {
  if(! -d $todir) { last; }
  $todir=$basedir.".".$i;
  $i++;
  }

my $cmd="cp -r $mtd_wrk_dir $todir";
system($cmd);
  
if(! -d $todir) {
  print STDERR "Results could not be copied to specified output directory $output_dir\n";
  }


}

#############
sub saveDir
#############
{

my $dirname=shift;
my $output_dir=shift;
my $target=shift;

my $basedir="$output_dir/$dirname.$target";
my $todir=$basedir;
my $i=2;
while(1) {
  if(! -d $todir) { last; }
  $todir=$basedir.".".$i;
  $i++;
  }

my $cmd="cp -r $main::tgt_wrk_dir/$dirname $todir";
system($cmd);

if(! -d $todir) {
  print STDERR "Results could not be copied to specified output directory $output_dir\n";
  }

}

 

#############
sub printLogs
#############
{

my $target=shift;
my $ref_cfg=shift;
my %cfg = %$ref_cfg;

getTargetData($target);

my @pipsteps=( "T", "A", "M", "R", "E" );

my $errors;

my $step;
foreach $step ( @pipsteps ) {

  my $mtdlist=$cfg{$step};
  my @mthds=split(/,/,$mtdlist);

  my $mtd;
  my $directory;
  foreach $mtd (@mthds) { 
    printErrors($mtd,$target);
    printOutput($mtd,$target);
    }
 
  $mtdlist=$cfg{$step."a"};
  @mthds=split(/,/,$mtdlist);

  foreach $mtd (@mthds) {
    printErrors($mtd,$target);
    printOutput($mtd,$target);
    }

  }

}



#############
sub printErrors
#############
{

my $mtd =shift;
my $tid = shift;

my $mtd_name=$main::methods{$mtd}{name};
print STDERR "################\n";
print STDERR "Errors for method $mtd_name\n";
print STDERR "################\n\n";

my $cmd="ls -1 -d $main::tgt_wrk_dir".$mtd."/results.*";
my @outdirs=`$cmd`;
my $directory;
foreach $directory (@outdirs) {
  chop $directory;
  my $file="$directory/errors";
  if(! -e $file) {
    print STDERR "No errors found for target $tid, method $mtd ($file)\n";
    next;
    }
  `cat $file >> $main::tgt_wrk_dir/errors`;
  `echo "\n----------------\n\n" >> $main::tgt_wrk_dir/errors`;
  }

}


#############
sub printOutput
#############
{

my $mtd =shift;
my $tid = shift;

my $mtd_name=$main::methods{$mtd}{name};
print "################\n";
print "Output for method $mtd_name\n";
print "################\n\n";

my $cmd="ls -1 -d $main::tgt_wrk_dir".$mtd."/results.*";
my @outdirs=`$cmd`;
my $directory;
foreach $directory (@outdirs) {
  chop $directory;
  my $file="$directory/output";
  if(! -e $file) {
    print "No output found for target $tid, method $mtd ($file)\n";
    next;
    }
  `cat $file >> $main::tgt_wrk_dir/errors`;
  `echo "\n----------------\n\n" >> $main::tgt_wrk_dir/output`;
  }

}


#############
sub useData
#############

{

my $resultsfile=shift;
my $type=shift;
my $tgtdir=shift;

my @results=`cat $resultsfile`;

my $rtype;
my $ext;
if($type eq "T") { $rtype="templates"; $ext="pdb"; }
elsif($type eq "A") { $rtype="alignments"; $ext="pir"; }
elsif($type eq "M") { $rtype="models"; $ext="pdb"; }

my $rfile="$tgtdir/use_$rtype.results";
open(RSLTS,">$rfile");

if(!-e $rfile) {
  print STDERR "Could not open $rfile\n";
  return "";
  }

my $line;
foreach $line (@results) {
  chop $line;

  my @data=split(/\t/,$line);
  my $file=$data[0];
  my $label=$data[1];
  if(!$label) {
    print STDERR "No result label specified for file $file.  Skipping\n";
    next;
    }
  
  if(!-e $file) {
    print STDERR "Result file $file not found.  Skipping.\n";
    next;
    }

  my $destfile="$tgtdir/$rtype/$label.$ext";
  my $cmd="cp $file $destfile";
  system($cmd);

  if(!-e $destfile) {
    print STDERR "Could not create $destfile.  Skipping $file.\n";
    next;
    }

  my $i;
  for($i=1;$i<@data;$i++) { print RSLTS "$data[$i]\t"; }
  print RSLTS "\n";

  }

close RSLTS;

return $rfile;

}

##########################
sub useGeneralData
##########################

{

my $tid=shift;
my $filelist=shift;
my $tgtdir=shift;

if(!-e $filelist) {
  print STDERR "Could not open $filelist\n";
  return;
  }

my @files=`cat $filelist`;

my $file;
foreach $file (@files) {
  chop $file;

  if(!$file) { next; }
  my @data=split(/\t/,$file);

  $file=$data[0];
  my $destfile=$data[1];

  if(!-e $file) {
    print STDERR "Result file $file not found.  Skipping.\n";
    next;
    }

  if(!$destfile) { $destfile=$file; }
  else {
    $destfile =~ s/TARGET/$tid/g; 
    }

  $destfile =~ s#.*/##;
  $destfile = $tgtdir.$destfile;

  my $cmd="cp $file $destfile";
  system($cmd);

  if(!-e $destfile) {
    print STDERR "Could not create $destfile.  Skipping $file.\n";
    next;
    }
  }

}


##########################
sub get_scop_pdbstyle_file
##########################
{

    my $scopid = shift;
    my $scopdir = $main::parameters{scop_pdb};

    if( $scopid =~ /d.(..).../ )
    {
	#my $template_file = "$scopdir"."$1"."/"."$scopid".".pdb";
	my $template_file = "$scopdir"."/"."$1"."/"."$scopid".".pdb";
	return $template_file;
    }
}


#############
sub parseBlastXML
#############

{

my ($ifile,$ofile) = @_;

my @hitdata=`egrep "Hit_id|Hit_def|Hit_len|Hsp_num|Hsp_evalue|Hsp_query-from|Hsp_query-to|Hsp_hit-from|Hsp_hit-to|Hsp_identity|Hsp_positive|Hsp_gaps|Hsp_align-len" $ifile`;

open(ALLHTS,">$ofile");

my $line;
my $ident;
my $alilen;
my $pos;
my $gaps=0;
my $hspnum=1;
foreach $line (@hitdata) {

  my @data=split(/[\<\>]/,$line);
  if($hspnum!=1) {
    my @begin=grep(/Hit_id/,@data);
    if(!@begin) { next; }
    $hspnum=1;
    }

  while($#data>-1) {
    my $temp=shift @data;
    if($temp eq "Hsp_num") {
      $hspnum=$data[0];
      last;
      }
    if($temp eq "Hit_id") {
      $data[0] =~ s/lcl\|//g;
      print ALLHTS $data[0]."\t";
      last;
      }
    if($temp eq "Hit_def") {
      print ALLHTS $data[0]."\t";
      last;
      }
    if($temp eq "Hit_len") {
      print ALLHTS $data[0]."\t";
      last;
      }
    if($temp eq "Hsp_evalue") {
      print ALLHTS $data[0]."\t";
      last;
      }
    if($temp eq "Hsp_query-from") {
      print ALLHTS $data[0]."\t";
      last;
      }
    if($temp eq "Hsp_query-to") {
      print ALLHTS $data[0]."\t";
      last;
      }
    if($temp eq "Hsp_hit-from") {
      print ALLHTS $data[0]."\t";
      last;
      }
    if($temp eq "Hsp_hit-to") {
      print ALLHTS $data[0]."\t";
      last;
      }
    if($temp eq "Hsp_identity") {
      $ident=$data[0];
      last;
      }
    if($temp eq "Hsp_positive") {
      $pos=$data[0];
      last;
      }
    if($temp eq "Hsp_gaps") {
      $gaps=$data[0]."\t";
      last;
      }
    if($temp eq "Hsp_align-len") {
      $alilen=$data[0];
      print ALLHTS sprintf("%i\t%i\t%.2f%%\t%i\t%.2f%%\t%i\n",$gaps,$ident,$ident/$alilen*100.0,$pos,$pos/$alilen*100.0,$alilen);
      $gaps=0;
      last;
      }
    }
  }

close ALLHTS;


}



#############
sub getRCSBSeq
#############

{

my $pdbid=shift;
my $chainid=shift;

my $updbid = $pdbid;
$updbid =~ y/a-z/A-Z/;
my $uchainid = $chainid;
$uchainid =~ y/a-z/A-Z/;

if(!$chainid) {
  #LWP::Simple::getstore("http://www.rcsb.org/pdb/cgi/getSequence.cgi/$updbid.fasta?chId=$updbid&format=fasta","$pdbid.fa");
  getstore("http://www.rcsb.org/pdb/cgi/getSequence.cgi/$updbid.fasta?chId=$updbid&format=fasta","$pdbid.fa");
  }
else {
  my $rcsbseqid="$updbid:$uchainid";
  #LWP::Simple::getstore("http://www.rcsb.org/pdb/cgi/getSequence.cgi/$rcsbseqid.fasta?chId=$rcsbseqid&format=fasta","$pdbid"."_"."$chainid.fa");
  getstore("http://www.rcsb.org/pdb/cgi/getSequence.cgi/$rcsbseqid.fasta?chId=$rcsbseqid&format=fasta","$pdbid"."_"."$chainid.fa");
  }


}


#############
sub getRCSBStr
#############

{

my $pdbid=shift;
my $chainid=shift;

getPipelineData();

$pdbid =~ y/A-Z/a-z/;
$chainid =~ y/A-Z/a-z/;

#LWP::Simple::getstore("ftp://ftp.rcsb.org/pub/pdb/data/structures/all/pdb/pdb$pdbid.ent.Z","$pdbid.pdb.Z");
#getstore("ftp://ftp.rcsb.org/pub/pdb/data/structures/all/pdb/pdb$pdbid.ent.Z","$pdbid.pdb.Z");
getstore("ftp://ftp.wwpdb.org/pub/pdb/data/structures/all/pdb/pdb$pdbid.ent.Z","$pdbid.pdb.Z");

if(!-e "$pdbid.pdb.Z") {
  print STDERR "Could not download structure for $pdbid\n";
  return "";
  }

`uncompress $pdbid.pdb.Z`;

if(!$chainid) { return "$pdbid.pdb"; }

my $chainfn=extractChain($pdbid,$chainid);

`rm $pdbid.pdb`;

return $chainfn;


}



#############
sub extractChain
#############

{

my $pdbid=shift;
my $chainid=shift;
my $dstfn=shift;

if($chainid eq "") { $chainid="_"; }

getPipelineData();

my $pdbdir=$main::parameters{pdb_directory};
my $srcfn;
if(!$dstfn) { $dstfn="$pdbid$chainid.pdb"; }
if(!-e "$pdbdir/$pdbid.pdb") {
  print STDERR "$pdbdir/$pdbid does not exist.  Trying to download from RCSB... ";
  $srcfn="./$pdbid.pdb";
  #LWP::Simple::getstore("ftp://ftp.rcsb.org/pub/pdb/data/structures/all/pdb/pdb$pdbid.ent.Z","$srcfn.Z");
  #getstore("ftp://ftp.rcsb.org/pub/pdb/data/structures/all/pdb/pdb$pdbid.ent.Z","$srcfn.Z");
  getstore("ftp://ftp.wwpdb.org/pub/pdb/data/structures/all/pdb/pdb$pdbid.ent.Z","$srcfn.Z");
  if(!-e "$srcfn.Z") {
    print STDERR "Failed.\n";
    return "";
    }
   print "Successful.\n";
  `uncompress -f $srcfn.Z`;
  }
else { $srcfn="$pdbdir/$pdbid.pdb"; }
  
#my $cmd="$main::pdg_root_dir/bin/extract $srcfn \"chain $chainid and (NAME GLY OR NAME ALA OR NAME VAL OR NAME LEU OR NAME ILE OR NAME MET OR NAME PHE OR \
#   NAME TRP OR NAME CYS OR NAME PRO OR NAME SER OR NAME THR OR NAME TYR OR NAME ASN OR NAME GLN OR NAME LYS OR NAME ARG OR NAME GLU OR NAME ASP OR \
#   NAME HIS OR NAME MSE)\"";

#change to make easier to add new modified residues
my $aafn = "$ENV{MOUNTDIR}/common/pudge/dat/known_aa.txt";
#my $string = `cat $aafn | awk '{printf("NAME %s OR"),$1}'`; works on system, not from here
my @aa = `cat $aafn`;
my $string = '( ';
foreach (@aa){
   my @parts = split(' ',$_);
   $string .= " NAME $parts[0] OR ";
}
  $string =~ s/\n//g; #join in 1 line
  $string =~ s/OR $//; #remove last OR
  $string .= ")";
  
#print STDERR "$string \n";exit;
my $cmd="$main::pdg_root_dir/bin/extract $srcfn \"chain $chainid and $string \"";
#my $cmd="$main::pdg_root_dir/bin/extract $srcfn \"chain $chainid and (NAME  ALA OR NAME  VAL OR NAME  PHE OR NAME  PRO OR NAME  MET OR NAME  ILE OR \
#NAME  LEU OR NAME  ASP OR NAME  GLU OR NAME  LYS OR NAME  ARG OR NAME  SER OR NAME  THR OR NAME  TYR OR NAME  HIS OR NAME  CYS OR NAME  ASN OR NAME  GLN \
#OR NAME  TRP OR NAME  GLY OR NAME  UNK OR NAME  2AS OR NAME  3AH OR NAME  5HP OR NAME  ACL OR NAME  AGM OR NAME  AIB OR NAME  ALM OR NAME  ALO OR \
#NAME  ALY OR NAME  ARM OR NAME  ASA OR NAME  ASB OR NAME  ASK OR NAME  ASL OR NAME  ASQ OR NAME  ASX OR NAME  AYA OR NAME  BCS OR NAME  BHD OR NAME \
# BMT OR NAME  BNN OR NAME  BUC OR NAME  BUG OR NAME  C5C OR NAME  C6C OR NAME  CCS OR NAME  CEA OR NAME  CGU OR NAME  CHG OR NAME  CLE OR NAME  CME \
#OR NAME  CSD OR NAME  CSO OR NAME  CSP OR NAME  CSS OR NAME  CSW OR NAME  CSX OR NAME  CXM OR NAME  CY1 OR NAME  CY3 OR NAME  CYG OR NAME  CYM \
#OR NAME  CYQ OR NAME  DAH OR NAME  DAL OR NAME  DAR OR NAME  DAS OR NAME  DCY OR NAME  DGL OR NAME  DGN OR NAME  DHA OR NAME  DHI OR NAME  DIL\
# OR NAME  DIV OR NAME  DLE OR NAME  DLY OR NAME  DNP OR NAME  DPN OR NAME  DPR OR NAME  DSN OR NAME  DSP OR NAME  DTH OR NAME  DTR OR NAME  DTY\
# OR NAME  DVA OR NAME  EFC OR NAME  FLA OR NAME  FME OR NAME  GGL OR NAME  GL3 OR NAME  GLX OR NAME  GLZ OR NAME  GMA OR NAME  GSC OR NAME  HAC\
# OR NAME  HAR OR NAME  HIC OR NAME  HIP OR NAME  HMR OR NAME  HPQ OR NAME  HTR OR NAME  HYP OR NAME  IIL OR NAME  IYR OR NAME  KCX OR NAME  LLP \
#OR NAME  LLY OR NAME  LTR OR NAME  LYM OR NAME  LYZ OR NAME  MAA OR NAME  MEN OR NAME  MHS OR NAME  MIS OR NAME  MLE OR NAME  MPQ OR NAME  MSA \
#OR NAME  MSE OR NAME  MVA OR NAME  NEM OR NAME  NEP OR NAME  NLE OR NAME  NLN OR NAME  NLP OR NAME  NMC OR NAME  OAS OR NAME  OCS OR NAME  OMT\
# OR NAME  PAQ OR NAME  PCA OR NAME  PEC OR NAME  PHI OR NAME  PHL OR NAME  PR3 OR NAME  PRR OR NAME  PTR OR NAME  SAC OR NAME SAR OR NAME  SCH\
# OR NAME  SCS OR NAME  SCY OR NAME  SEL OR NAME  SEP OR NAME  SET OR NAME  SHC OR NAME  SHR OR NAME  SMC OR NAME  SOC OR NAME  STY OR NAME  SVA\
# OR NAME  TIH OR NAME  TPL OR NAME  TPO OR NAME  TPQ OR NAME  TRG OR NAME  TRO OR NAME  TYB OR NAME  TYQ OR NAME  TYS OR NAME  TYY)\"";

#print "$cmd\n";

`($cmd > $dstfn) >& /dev/null`;

return $dstfn;

}


#############
sub createTempDir
#############

{

my $tmpdir=`date +%w%H%S`;
chop($tmpdir);
while (1) {
  #if(! -d "$tmpdir") {  this was failing on trantor, checking on NULL
  if(! -e "$tmpdir") {   ##-e        File or directory exists? Kely 06/12/06
   `mkdir $tmpdir`;
   if(!$?) { 
     `chmod a+rw $tmpdir`;
     last;
     }
   }
  $tmpdir++;
  }
##don't understand why is this here....above will loop till done! Kely 06/8/06
if(!-d "$tmpdir") {
  print STDERR "Could not create directory $tmpdir.  Exiting.\n";
  exit;
  }

return $tmpdir;

}


#############
sub getPDBId
#############

{

my $tid=shift;

my $pdbcode;
if(substr($tid,0,1) eq "d") { $pdbcode=substr($tid,1,4); }
else { $pdbcode=substr($tid,0,4); }
  
return $pdbcode;

}

#############
sub checkExe
#############

{

my @exe=@_;

my $exeok=1;

my $file;
foreach $file (@exe) {
  if(-x $file) { next; }
  print STDERR "$file not found.\n";
  $exeok=0;
  }

return $exeok;

}


#############
sub excludeTemplates
#############

{

my $target=shift;
my $resultsf=shift;

getPipelineData();
my $ref_cfg = &pudgeUtil::readConfig("$main::pdg_wrk_dir/$target/$target.cfg");
my %cfg = %$ref_cfg;

my $data=$cfg{exclude_templates};
if($data eq "none") { return; }
my @ex_templates=split(/[, ]/,$data);

my $egrep;

if(!@ex_templates) { return; }
while (@ex_templates) {
  my $ttmp=shift @ex_templates;
  $egrep.="$ttmp";
  if(!@ex_templates) { last; }
  $egrep.="|";
  }

print "egrep -v \"$egrep\" $resultsf\n";
my @results=`egrep -v "$egrep" $resultsf`;

open(RESF,">$resultsf");
print RESF @results;
close RESF;

}


#############
sub separateJobs
#############

{

my $inputfn=shift;
my $prms=shift;
my $nproc=shift;
my $label=shift;
my $script=shift;

my $joblabel=$label.`date +%w%H%S`;
chop($joblabel);
while (1) {
  my @jobs=`qstat | grep $joblabel`;
  if(@jobs) { $joblabel++; next; }
  last;
  }

my $i=1;
my $j=0;
my @ilines=`cat $inputfn`;
my $line;
foreach $line (@ilines) {
  chop $line;
  open(CMDLST,">>$joblabel.input.$i");
  print CMDLST $line."\n";
  close CMDLST;
  if(($j%$nproc)==0) { $i++; }
  }

for($i=1;$i<=$nproc;$i++) {
  if(!-e "$joblabel.input.$i") { last; }
  my $subscr="$joblabel.$i.csh";
  `echo "$script $joblabel.input.$i $prms" > $subscr`;
  print STDERR `qsub -cwd -e $joblabel.$i.errors -o $joblabel.$i.output $subscr`;
  }

&pudgeUtil::waitForJobs("MM$joblabel",1);

}


#############
sub checkConfig
#############

{

my $ref_cfg = shift;
my %cfg = %$ref_cfg;

my %methods = &pudgeUtil::readMtdRdbByName($main::pdg_mtd_db);

foreach my $step ( "T", "A", "M", "R", "E" , "Ta", "Aa", "Ma", "Ra", "Ea" ) {
  my $tmp=$cfg{$step};
  my @mtds=split(/,/,$tmp);
  my $mtd;
  my @tmp_mtds = ();
  foreach $mtd ( @mtds ) {  
    if(!$methods{$mtd}) {
      print STDERR "Method $mtd is not of type $step.  Skipping.\n";
      next;
      }
    if($methods{$mtd}{type} ne $step) {
      print STDERR "Method $mtd is not of type $step.  Skipping.\n";
      next;
      }
    push(@tmp_mtds,$mtd);
    }
  $tmp="";
  foreach $mtd (@tmp_mtds) { $tmp.=$mtd.","; }
  chop $tmp;
  $cfg{$step}=$tmp;
  }

if(!$cfg{T}) { $cfg{T}="no_template_selection"; }
if(!$cfg{A}) { $cfg{A}="no_alignment"; }
if(!$cfg{M}) { $cfg{M}="no_model_building"; }
if(!$cfg{R}) { $cfg{R}="no_model_refinement"; }
if(!$cfg{E}) { $cfg{E}="no_model_evaluation"; }
if(!$cfg{Ta}) { $cfg{Ta}="no_template_selection_analysis"; }
if(!$cfg{Aa}) { $cfg{Aa}="no_alignment_analysis"; }
if(!$cfg{Ma}) { $cfg{Ma}="no_model_building_analysis"; }
if(!$cfg{Ra}) { $cfg{Ra}="no_refinement_analysis"; }
if(!$cfg{Ea}) { $cfg{Ea}="no_model_evaluation_analysis"; }
if(!$cfg{To}) { $cfg{To}="none"; }
if(!$cfg{Ao}) { $cfg{Ao}="none"; }
if(!$cfg{Mo}) { $cfg{Mo}="none"; }
if(!$cfg{Ro}) { $cfg{Ro}="none"; }
if(!$cfg{Eo}) { $cfg{Eo}="none"; }
if(!$cfg{models}) { $cfg{models}="none"; }
if(!$cfg{alignments}) { $cfg{alignments}="none"; }
if(!$cfg{templates}) { $cfg{templates}="none"; }
if(!$cfg{use_data}) { $cfg{use_data}="none"; }
if(!$cfg{target_pdb}) { $cfg{target_pdb}="none"; }
if(!$cfg{exclude_templates}) { $cfg{exclude_templates}="none"; }

return \%cfg;

}

#############
sub lock_file()  #looks file even on NFS system, unlock when closing file
#############    Norel, 08V07 
{
                                                                                                                                  
use File::NFSLock qw(uncache);
use Fcntl qw(LOCK_EX LOCK_NB);
                                                                                                                                  
                                                                                                                                  
                                                                                                                                  
my $fn = shift;
`echo $fn > /razor/4/norel/nu`;
my $lock = new File::NFSLock ($fn, LOCK_EX)
    or print "Ouch1, problems with NFSlock  \n"; # blocking lock (Exclusive)
                                                                                                                                  
                                                                                                                                  
return $lock;
}

###############
sub check_pudge_status2() #look in a directory on many jobs are done, running or pending to run
###############          #need to distinguish between checking web_xxx or directly P0xxxx
{
my ($pid, $url,$dir_name ) = @_;
my $dir = "$ENV{MOUNTDIR}/www/pudge/guest/wrk/$pid";
if (! -d $dir){return ("don't find $dir");}
my $text = "";
#case of multiple submittion(sp?)
if ($pid =~ /^web/){
#print "web.... => multiple sub \n";
#not always the fasta file ends in .fa....
#my $fa_fn = `ls -1 $dir/*fa`;
chdir $dir;
my $fa_fn = `grep target_seq *`;
my @parts = split(" ",$fa_fn);
$fa_fn = $parts[1];
my @fa_lines = `grep ">" $fa_fn`;
my $n = scalar (@fa_lines);
 $text .= "You submitted $n job";
if ($n > 1){
   $text .="s";
}
  $text .= "<br>";

my @lsAll = `ls -l $dir/P*`;
  $text .= "\n";
my $done=0;
  if ($#lsAll > -1 ){
     $text .= "<p>\n PUDGE results can be analyzed here: <p>  \n";
  }
foreach (@lsAll){
  chomp $_;
  @parts = split("/",$_);
  # read config
  my $cfg_file = "$dir/$parts[$#parts]/$parts[$#parts].cfg";
  my $ref_cfg = &readConfig($cfg_file);
  my $pid = $parts[$#parts];
  my $flag = &pipelineDone($parts[$#parts],$ref_cfg);
  
  if ($flag ==1) {
     $done++;
      $text .= "<p> <a href=$APR?pid=pid&input=$pid>$pid Done</a> <p> \n";
  }
  else{
      $text .= "<p> <a href=$APR?pid=pid&input=$pid>$pid Running </a> <p> \n";
  }
   
}

 $text .= "$done job";
 if ($done < 2){
  $text .=" is ";
}
else{
  $text .= " are "
}
  $text .= "ready.";
if ($done == $n){
  $text .= "<br> This completes this job.<br>";
}
}#end if web_xxx
else{
# read config
  #my $cfg_file = "$dir/$pid/$pid.cfg";
  my $cfg_file = "$dir/$pid.cfg";
  my $ref_cfg = &readConfig($cfg_file);
  my $flag = &pipelineDone($pid,$ref_cfg);
  my $schedule_fn = "$ENV{MOUNTDIR}/www/pudge/guest/wrk/schedule.log";
  my $pending = `grep $pid $schedule_fn`;
  if ($pending =~ /Pending/){
     $text = "<B> <p> Pending to Start </B>\n"; 
  }
  else {
     $text = "<p>\n PUDGE results can be analyzed here: <p>  \n";
     my $fnl = "$dir/lock";
     if ($flag == 1) {
         $text .= "<p> <a href=$APR?pid=pid&input=$pid>$pid Done</a> <p> \n";
     }
     elsif (-e $fnl) {
        $text .= "<p> <a href=$APR?pid=pid&input=$pid>$pid Running</a> <p> \n";
     }
     else {
       $text .= "<p> Calculations are done, finishing with output display. Please refresh status <p> \n";
     }
  }
                                                                                                                                                   
}

$text .= "<p><big><big><tt><FONT COLOR=green style=\"background: #FFFBC6\">
           Please bookmark this page to
            </FONT></tt></big></big>  \n";
 $text .= " <a href=$url?status=1&jobID=$pid&dir_name=$dir_name>Update Status</a>" ;
 $text .= "<p> <small> Currently we are NOT sending e-mail notifications.
           If you prefer to have them, please contact
             <a href =$admin_mail > $admin_name </a> for assistance. </small>";
                                                                                                                                                   
return ($text);
}

###############
sub check_pudge_status() #look in a directory on many jobs are done, running or pending to run
###############          #need to distinguish between checking web_xxx or directly P0xxxx
{
my ($pid, $url,$dir_name ) = @_;
my $dir = "$ENV{MOUNTDIR}/www/pudge/guest/wrk/$pid";
if (! -d $dir){return ("don't find $dir");}
my $text;
#case of multiple submittion(sp?)
if ($pid =~ /^web/){
#print "web.... => multiple sub \n";
my @ls = `ls -l $dir/*.2resub.cfg`;
my $n = scalar (@ls);
 $text = "You submitted $n job";
if ($n > 1){
 $text .= "s"
}
 $text .= ".\n <p> ";

my  @lsRun = `ls -l $dir/P*/lock`;
my $r = scalar (@lsRun);
 $text .= "$r ";
if ($r == 1 ){
  $text .=" is ";
}
else{
  $text .= "are "
}
 $text .= "running-- \n ";

my  @lsDon = `ls -l $dir/P*/DONEALL`;
my $d = scalar (@lsDon);
 $text .= "$d ";
if ($d == 1 ){
  $text .=" is ";
}
else{
  $text .= "are "
}
 $text .= "ready-- \n";

my $p = $n - ($d + $r);
if ($p>0){
  $text .= " $p";
if ($p == 1 ){
  $text .=" is ";
}
else{
  $text .= " are ";
}
  $text .= "pending to start-- \n" ;

}
 my $pdir;
 if (($d + $r) > 0) {
    $text .= "<p>\n PUDGE results can be analyzed here: <p>  \n";
 }
 for(my $i=0; $i<$d; $i++){
     ($pdir) = $lsDon[$i] =~ /(P\d{5})/;
    $text .= "<p> <a href=$APR?pid=pid&input=$pdir>$pdir Done</a> <p> \n";
 }
 for(my $i=0; $i<$r; $i++){
     ($pdir) = $lsRun[$i] =~ /(P\d{5}).lock/;
   $text .= "<p> <a href=$APR?pid=pid&input=$pdir>$pdir Running </a> <p> \n";
 }
}#end if web_xxx
else{
my $fnl = "$dir/lock";
my $fnd = "$dir/pipeline_done";
my $fn2 = "$dir/2resub";
my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime1,$ctime,$blksize,$blocks)=stat($fnd);
my $mtime2;
 ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime2,$ctime,$blksize,$blocks)=stat($fn2);
  if ($mtime2 < $mtime1){
     $text = "<p>\n PUDGE results can be analyzed here: <p>  \n";
     $text .= "<p> <a href=$APR?pid=pid&input=$pid>$pid Waiting to start</a> <p> \n";
  }
  elsif (-e $fnl) {
     $text = "<p>\n PUDGE results can be analyzed here: <p>  \n";
     $text .= "<p> <a href=$APR?pid=pid&input=$pid>$pid Running</a> <p> \n";
  }
  elsif (-e $fnd) { 
     $text = "<p>\n PUDGE results can be analyzed here: <p>  \n";
     $text .= "<p> <a href=$APR?pid=pid&input=$pid>$pid Done</a> <p> \n";
  }

}
$text .= "<p><big><big><tt><FONT COLOR=green style=\"background: #FFFBC6\">
           Please bookmark this page to
            </FONT></tt></big></big>  \n";
 $text .= " <a href=$url?status=1&jobID=$pid&dir_name=$dir_name>Update Status</a>" ;
 $text .= "<p> <small> Currently we are NOT sending e-mail notifications.
           If you prefer to have them, please contact
             <a href =$admin_mail > $admin_name </a> for assistance. </small>";


return ($text);
}

###########################
sub mail_results(){
###########################
my ($pid) = @_;
my $send_mail = '/usr/sbin/sendmail'; #venus

   if (! -e $send_mail) { die  "didn't find $send_mail. OOPS! Bye bye. \n";}
my $mail_body .= "This is an automatically generated message from HonigLab. If you have any questions please contact";
$mail_body .= "  honig_software\@c2b2.columbia.edu \n\n";

my $dir = "$ENV{MOUNTDIR}/www/pudge/guest/wrk/$pid";
my  @lsDon = `ls -l $dir/P*/pipeline_done`;
my $d = scalar (@lsDon);
my $pdir;
($pdir) = $lsDon[0] =~ /(P\d{5})/;
my $email = `cat "$dir/$pdir/user_mail"`;
if ($email eq "") {die "Don't have your e-mail. Bye \n";}
#print "tengo email? $email \n";

   for (my $i=0; $i<$d; $i++){
      #$mail_body .=  "<a href=$APR?pid=pid&input=$pdir>results for $pdir </a> \n";
      $mail_body .=  "results for $pdir: $APR?pid=pid&input=$pdir \n";
   }
                                                                                                                                                           
   open(MAIL,"|$send_mail -oi -t") or die "Can't open pipe to $send_mail:$!\n";
   print MAIL "To: $email\n";
   print MAIL "From: honig_software\@c2b2.columbia.edu \n";
   print MAIL "Subject: PUDGE results\n\n";
   print MAIL "$mail_body\n";
   close(MAIL) or die "Can't close pipe to $send_mail: $!\n"; 
}

###########################
sub checkENV(){             #check if needed ENV variables are NOT defined, define with defaults
###########################
$ENV{MOUNTDIR} = '/razor/0' if( ! defined ($ENV{MOUNTDIR} ));
$ENV{TROLLTOP} = '/razor/0/common/pudge/dat/allh.top' if(! defined( $ENV{TROLLTOP} ));
$ENV{SUBMAT} = '/razor/0/common/pudge/dat/blosum62' if(! defined( $ENV{SUBMAT} ));
$ENV{JACKALDIR} = '/razor/0/common/pudge/dat/jackal.dir' if(! defined( $ENV{JACKALDIR} ));
$ENV{PDB_DIRECTORY} = '/razor/0/databases/pdb' if(! defined( $ENV{PDB_DIRECTORY} ));

 return;
}

#################
sub setShellEnv { #exprt ENV variables to shell
#################

	my $command = '';
	foreach my $var ( keys ( %ENV ) ) {
		$command .= "setenv $var " . $ENV{$var} . "\n";
	}
		
	return $command;

}

####################
sub obtainJobLabel {
######################
        my      $joblabel = `date +%w%H%S`;
        chop ($joblabel);
        while (1) {
                my @jobs=`qstat | grep $joblabel`;
           if(@jobs) { $joblabel++; next; }
           last;
        }
                                                                                
        return $joblabel;
}

########################
sub clean_word_from_file{ #clean tmp dir from .pal file from formatdb (by Norel)
########################
my ($file, $word) = @_;
if (! -e $file ){
   print STDERR "file $file not found, bye\n";
   return (-1);
}
open (OUT, " >  $file.TMP") or die "cannot open $file.TMP (why? $!) \n";
my @input = `cat $file`;
foreach my $line (@input){
   $line =~ s/$word//g;
   print OUT $line;
}
close OUT;
  `mv -f $file.TMP $file`;
}

########################
sub label_no_model_refinement{
########################
my ($tgtid, $dir)= @_;
my $fdir  = "$ENV{PUDGE}/wrk/$tgtid/$dir";
if (! -d $fdir) { return "Error, directory $fdir not found\n";}
my $fn = `ls -1  $fdir/sP*.sh`;
my $line = `head -1 $fn`;
my @parts = split (' ',$line);
my $index=0;
foreach (@parts){
   $index++;
   if ($_ eq '-i') {last;}
}
my @parts2 = split("/", $parts[$index]);
my $odir = "$ENV{PUDGE}/wrk/$tgtid/$parts2[7]/$parts2[8]"; #original directory
$fn = `ls -1  $odir/sP*.sh`;
$line = `head -1 $fn`;
@parts = split (' ',$line);
$index=0;
foreach (@parts){
   $index++;
   if ($_ eq '-i') {last;}
}
@parts2 = split("/", $parts[$index]);
my $label = `grep $parts2[7] $methodDb`;
@parts = split (/\t/,$label);

return ("$parts[1].$parts2[8]");
}

1; #loaded ok
